﻿/* Copyright 2010 © by YeZZx aka Crunkx */
using System;
using System.Net;
using System.Net.Sockets;
using System.Threading;

namespace LoginServer
{
    class cClient
    {
        public Socket ClientSocket;
        private cClientPacketHandler pHandler = new cClientPacketHandler();

        // Variabels
        private long sUserID = 0;
        private string sUsername = string.Empty;
        private string sPassword = string.Empty;
        private string sNickname = string.Empty;
        private int sAccesslevel = 0;
        private int sSessionID = 0;

        public cClient(Socket tSocket,int tSession)
        {
            ClientSocket = tSocket;

            cMain.WriteLine("cWRClient", "Accepted new Client [ " + ClientSocket.RemoteEndPoint.ToString().Split(new char[] { ' ' })[0] + " ]");
            Thread recvThread = new Thread(new ThreadStart(recvData));
            recvThread.Start();
        }

        private void recvData()
        {
            byte[] rBuffer = new byte[1024];
            byte[] rPacket;
            int rLength = 0;
            Send(new SP_CONNECT_PACKET());

            while (true)
            {
                try
                {
                    rLength = ClientSocket.Receive(rBuffer, 0, rBuffer.Length, SocketFlags.None);
                }
                catch { }

                if (ClientSocket.Connected && rLength > 0)
                {
                    rPacket = new byte[rLength];
                    Array.Copy(rBuffer, 0, rPacket, 0, rLength);
                    pHandler.HandlePacket(rPacket, this);
                }
                else
                {
                    break;
                }
            }
        }

        public void Send(cServerPacketHandler fPacket)
        {
            byte[] rPacket = fPacket.getPacket();
            ClientSocket.Send(rPacket, 0, rPacket.Length, SocketFlags.None);
        }

        public long getUserID() { return sUserID; }
        public string getUsername() { return sUsername; }
        public string getPassword() { return sPassword; }
        public string getNickname() { return sNickname; }
        public int getAccesslevel() { return sAccesslevel; }
        public int getSessionID() { return sSessionID; }

        public void setUserID(long tID) { sUserID = tID; }
        public void setUsername(string tUsername) { sUsername = tUsername; }
        public void setPassword(string tPassword) { sPassword = tPassword; }
        public void setNickname(string tNickname) { sNickname = tNickname; }
        public void setAccesslevel(int tAccesslevel) { sAccesslevel = tAccesslevel; }
        public void setSessionID(int tSessionID) { sSessionID = tSessionID; }

    }
}
/* Copyright 2010 © by YeZZx aka Crunkx */